/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.transmutations;

import codersafterdark.compatskills.CompatSkills;
import codersafterdark.compatskills.common.compats.reskillable.ReskillableCompatHandler;
import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.reskillable.api.transmutations.TransmutationRegistry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="reskillable")
@ZenClass(value="mods.compatskills.transmutations.additions")
@ZenRegister
public class AdditionsTweaker {
    @ZenMethod
    public static void addEntryToReagent(IItemStack reagent, IItemStack startState, IItemStack endState) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new AddEntryToReagent(CraftTweakerMC.getItemStack((IItemStack)reagent).func_77973_b(), startState, endState));
        }
    }

    @ZenMethod
    public static void addEntryToReagent(IItemStack reagent, crafttweaker.api.block.IBlockState state1, crafttweaker.api.block.IBlockState state2) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new AddEntryToReagent(CraftTweakerMC.getItemStack((IItemStack)reagent).func_77973_b(), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state1), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state2)));
        }
    }

    @ZenMethod
    public static void addEntryToReagentAgnostic(IItemStack startState, IItemStack endState) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new AddEntryToAgnosticReagent(startState, endState));
        }
    }

    @ZenMethod
    public static void addEntryToReagentAgnostic(crafttweaker.api.block.IBlockState state1, crafttweaker.api.block.IBlockState state2) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new AddEntryToAgnosticReagent(CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state1), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state2)));
        }
    }

    private static class AddEntryToAgnosticReagent
    implements IAction {
        private final IBlockState state1;
        private final IBlockState state2;

        private AddEntryToAgnosticReagent(IBlockState state1, IBlockState state2) {
            this.state1 = state1;
            this.state2 = state2;
        }

        private AddEntryToAgnosticReagent(IItemStack state1, IItemStack state2) {
            this.state1 = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state1));
            this.state2 = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state2));
        }

        public void apply() {
            TransmutationRegistry.addEntryReagentAgnostic((IBlockState)this.state1, (IBlockState)this.state2);
        }

        public String describe() {
            return "Added Transmutation for " + this.state1.func_177230_c().func_149732_F() + " -> " + this.state2.func_177230_c().func_149732_F() + " :: Using All Reagents";
        }
    }

    private static class AddEntryToReagent
    implements IAction {
        private final Item reagent;
        private final IBlockState state1;
        private final IBlockState state2;

        private AddEntryToReagent(Item reagent, IBlockState state1, IBlockState state2) {
            this.reagent = reagent;
            this.state1 = state1;
            this.state2 = state2;
        }

        private AddEntryToReagent(Item reagent, IItemStack state1, IItemStack state2) {
            this.reagent = reagent;
            this.state1 = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state1));
            this.state2 = CheckMethods.convertItemStackToIBlockState(CraftTweakerMC.getItemStack((IItemStack)state2));
        }

        public void apply() {
            TransmutationRegistry.addEntryToReagent((Item)this.reagent, (IBlockState)this.state1, (IBlockState)this.state2);
        }

        public String describe() {
            return "Added Transmutation for " + this.state1.func_177230_c().func_149732_F() + " -> " + this.state2.func_177230_c().func_149732_F() + " :: Using Reagent: " + new ItemStack(this.reagent).func_82833_r();
        }
    }
}

